<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Página no encontrada (Error 404) - PlusMusicas</title>
    <style>
        body {
          	background-color: #0a2038; /* Fondo color #0a2038 */
            font-family: verdana, sans-serif;
            color: #FFF; /* Texto en blanco */
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
        }

        .error-container {
            text-align: center;
        }

        .error-title {
            font-size: 7em;
            color: #FF0000; /* Rojo para el título de error */
            margin-bottom: 20px;
        }

        .error-message {
            font-size: 3em;
            color: #FFF; /* Texto en blanco para el mensaje de error */
            margin-bottom: 30px;
        }

        .search-container {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .search-message {
            font-size: 1.2em;
            color: #FFF; /* Texto en blanco para el mensaje de búsqueda */
            margin-bottom: 10px;
        }

        .search-box {
            width: 300px;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .search-button {
            padding: 10px 20px;
            background-color: #FF0000; /* Rojo para el botón de búsqueda */
            color: #FFF; /* Texto en blanco para el botón de búsqueda */
            border: none;
            border-radius: 5px;
            font-size: 1em;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-title">Error 404</div>
        <div class="error-message">Página no encontrada (Fuera de servicio)</div>
        <div class="search-container">
            <div class="search-message">¿Te ayudamos? Busca lo que no encontraste en el siguiente buscador:</div>
            <form id="searchForm" action="">
                <input type="text" class="search-box" id="searchQuery" placeholder="Buscar en PlusMusicas">
                <button type="submit" class="search-button">Buscar</button>
            </form>
        </div>
        <a href="http://plusmusicas.com/" style="text-decoration: none; color: #FF0000;">Ir a la página de inicio de PlusMusicas</a>
    </div>

<script>
    document.getElementById('searchForm').addEventListener('submit', function(event) {
        event.preventDefault();
        var searchQuery = document.getElementById('searchQuery').value;
        // Reemplazar espacios con guiones (-)
        searchQuery = searchQuery.replace(/\s+/g, '-');
        window.location.href = '/mp3/' + encodeURIComponent(searchQuery) + '/';
    });
</script>

</body>
</html>


