<?php
// Autenticación HTTP básica
if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW']) || 
    $_SERVER['PHP_AUTH_USER'] !== 'owner' || $_SERVER['PHP_AUTH_PW'] !== '/*Relocos') {
    header('WWW-Authenticate: Basic realm="Contenido protegido"');
    header('HTTP/1.0 401 Unauthorized');
    echo 'Autenticación requerida';
    exit;
}

// Configuración de la base de datos
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexión
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Establecer la codificación de caracteres a utf8mb4
$conn->set_charset("utf8mb4");

// Procesar el formulario al enviar
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Datos del formulario
    $artista = $_POST['artista'];
    //$link_bioartista = strtolower(str_replace(' ', '-', preg_replace('/[^A-Za-z0-9\-]/', '', $artista)));
	$link_bioartista = strtolower(preg_replace('/[^A-Za-z0-9\-]/', '', str_replace(' ', '-', $artista)));
    $biografia = $_POST['biografia'];
    $fecha_publicacion = date("Y-m-d");

    // Verificar si el artista ya existe en la tabla biografias
    $sql_check = "SELECT id FROM biografias WHERE artista = ? OR link_bioartista = ?";
    $stmt_check = $conn->prepare($sql_check);
    $stmt_check->bind_param("ss", $artista, $link_bioartista);
    $stmt_check->execute();
    $stmt_check->store_result();

    if ($stmt_check->num_rows > 0) {
        echo "La biografía de este artista ya existe y no se guardará de nuevo.<br>";
    } else {
        // Insertar en la tabla biografias
        $sql_biografias = "INSERT INTO biografias (link_bioartista, artista, biografia, num_visitas, fecha_publicacion) 
                           VALUES (?, ?, ?, 0, ?)";
        $stmt_biografias = $conn->prepare($sql_biografias);
        $stmt_biografias->bind_param("ssss", $link_bioartista, $artista, $biografia, $fecha_publicacion);

        if ($stmt_biografias->execute()) {
            echo "Biografía insertada exitosamente.<br>";
            $biografia_id = $stmt_biografias->insert_id;
        } else {
            echo "Error al insertar la biografía: " . $stmt_biografias->error . "<br>";
        }

        // Procesar detalles ingresados en un solo campo
        $detalles_texto = $_POST['detalles'];
        $detalles_lineas = explode("\n", $detalles_texto);
        $sql_detalles = "INSERT INTO biografias_detalles (biografia_id, campo, valor) VALUES (?, ?, ?)";
        $stmt_detalles = $conn->prepare($sql_detalles);

        foreach ($detalles_lineas as $linea) {
            // Separar campo y valor usando ":" o "::"
            $partes = preg_split('/\s*::\s*|\s*:\s*/', trim($linea), 2);
            if (count($partes) == 2) {
                $campo = trim($partes[0]);
                $valor = trim($partes[1]);
                $stmt_detalles->bind_param("iss", $biografia_id, $campo, $valor);
                if ($stmt_detalles->execute()) {
                    echo "Detalle insertado: " . $campo . "<br>";
                } else {
                    echo "Error al insertar el detalle: " . $stmt_detalles->error . "<br>";
                }
            }
        }

        // Cerrar conexiones
        $stmt_biografias->close();
        $stmt_detalles->close();
    }

    $stmt_check->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar Biografía</title>
    <link rel="stylesheet" href="/css/agregarbiocss.css?v=3">
</head>
<body>
<div id="contenido">
    <h2>Agregar Biografía de Artista</h2>
    <form method="POST" action="agregarbiografia.php">
        <label for="artista">Nombre del Artista:</label><br>
        <input type="text" id="artista" name="artista" required><br><br>

        <label for="biografia">Biografía (HTML):</label><br>
        <textarea id="biografia" name="biografia" rows="10" cols="50" required></textarea><br><br>

        <h3>Detalles de la Biografía</h3>
        <label for="detalles">Detalles (un campo por línea, separa campo y valor con ":" o "::"):</label><br>
        <textarea id="detalles" name="detalles" rows="15" cols="50" placeholder="Ejemplo:\nNombre Verdadero: John Doe\nGénero:: Pop, Rock" required></textarea><br><br>
        
        <input type="submit" value="Guardar Biografía">
    </form>
</div>
</body>
</html>
