<?php
// Configuración de la conexión a la base de datos
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexión
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

// URLs a insertar
$urls = explode("\n", $_POST['urls']);

// Insertar cada URL en la tabla listaprincipal
foreach ($urls as $url) {
    // Saltamos las líneas vacías
    $url = trim($url);
    if ($url === '') {
        continue;
    }
    
    // Limpiar la URL de caracteres de control antes de procesarla
    $url = trim($url);
    
    // Extraer el nombre del artista y el nombre de la canción utilizando expresiones regulares
    preg_match('~top-img/(.*?) - ~', $url, $artista);
    preg_match('~ - (.*?)\.skm~', $url, $cancion);
    
    // Verificar que se encontraron coincidencias
    if (!isset($artista[1]) || !isset($cancion[1])) {
        echo "No se pudieron extraer datos de: $url <br>";
        continue;
    }
    
    // Eliminar espacios en blanco al principio y al final del nombre del artista y el nombre de la canción
    $artista[1] = trim($artista[1]);
    $cancion[1] = trim($cancion[1]);
    
    // Preparar la sentencia para prevenir inyección SQL
    $stmt = $conn->prepare("INSERT INTO listaprincipal (artista, cancion, url, hits) VALUES (?, ?, ?, 1)");
    $stmt->bind_param("sss", $artista[1], $cancion[1], $url);
    
    if ($stmt->execute()) {
        echo "URL insertada correctamente: " . htmlspecialchars($artista[1]) . " - " . htmlspecialchars($cancion[1]) . "<br>";
    } else {
        echo "Error: " . htmlspecialchars($url) . "<br>" . $conn->error . "<br>";
    }
    
    $stmt->close();
}

// Cerrar conexión
$conn->close();
?>