<?php
@include('./includes/cache.php');

/* Datos Web */
$sitename = "PlusMusicas";

/* Configuración BD */
$root = "https://wvw.plusmusicas.com";

// Función para establecer la conexión a la base de datos
function getDBConnection() {
    $db_host = 'localhost';
    $db_user = 'plusmusi_owner';
    $db_pass = '^@#F-NBx3W}+';
    $db_name = 'plusmusi_data';

    try {
        $conectar = new mysqli($db_host, $db_user, $db_pass, $db_name);
        if ($conectar->connect_error) {
            throw new Exception("Error de conexión: " . $conectar->connect_error);
        }
        $conectar->set_charset("utf8mb4");
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
        exit();
    }

    return $conectar;
}

/* Configuración Opcional */
$anio = "2024"; // Año que irá en los títulos

// Funciones de limpieza de texto y URL
function limpiar($cadena) {
    return ucwords(str_replace('-', ' ', str_replace('_', '-', $cadena)));
}

function limpiar_url($cadena) {
    return strtolower(str_replace(' ', '-', $cadena));
}

function limpiar_titulo($cadena) {
    return htmlspecialchars(trim(str_replace(array('&', 'ñ', '_', '"', "'"), array('Y', 'n', ' ', '', ''), $cadena)));
}

function limpiar_texto($cadena) {
    return limpiar(htmlspecialchars(preg_replace("/[^A-Za-z0-9 ]/", " ", $cadena)));
}

// Obtén el nombre del artista desde la URL
$artista = isset($_GET['query']) ? $_GET['query'] : '';

if (empty($artista)) {
    // Si no se proporciona un artista en la URL, selecciona uno aleatorio
    $sel = rand(0, 11);
    $bus = array("Bad Bunny", "Dyland y Lenny", "Plan B", "La Factoria", "Chino y Nacho", "Don Omar", "Rio Roma", "Chapa C", "Daddy Yankee", "Arcangel", "Wisin Y Yandel", "Corazon Serrano");
    $artista = $bus[$sel];
}

$nombreArtista = limpiar_texto($artista);

$title = "Biografía completa de $nombreArtista - $sitename";
$description = "Encuentra la biografía y las Lyrics de las canciones de $nombreArtista en $sitename. Explora y disfruta de su música y Lyrics.";
$keyword = "canciones de $nombreArtista, biografía, Lyrics de canciones, artista, música, $nombreArtista, $sitename, biografía de $nombreArtista";
$portada_url = "https://tse2.mm.bing.net/th?q=" . urlencode($artista) . "+cantante&w=600&h=350&c=7&rs=2&?.jpg";

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($title, ENT_QUOTES, 'UTF-8') ?></title>
    <meta name="title" content="<?= htmlspecialchars($title, ENT_QUOTES, 'UTF-8') ?>" />
    <meta name='description' content="<?= htmlspecialchars($description, ENT_QUOTES, 'UTF-8') ?>">
    <meta name="keywords" content="<?= htmlspecialchars($keyword, ENT_QUOTES, 'UTF-8') ?>">
    <link rel="canonical" href="<?= "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] ?>" />
    <meta property="og:image" content="<?= htmlspecialchars($portada_url, ENT_QUOTES, 'UTF-8') ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:site_name" content="<?= htmlspecialchars($sitename, ENT_QUOTES, 'UTF-8') ?>" />
    <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1" />
    <meta http-equiv="Content-Language" content="es,en,de,pt" />
    <meta name='robots' content='index, follow' />
    <meta name='googlebot' content='index, follow' />
    <meta name="copyright" content="<?= htmlspecialchars($sitename, ENT_QUOTES, 'UTF-8') ?> - Derechos Reservados" />
    <meta name="revisit" content="1 days" />
    <link rel="stylesheet" type="text/css" href="/css/plusmST2.css?v=1.5"/>
    <link rel="stylesheet" type="text/css" href="/css/movil.css?v=1.6"/>
	<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533" crossorigin="anonymous"></script>
</head>
<body>

<div id="header">
    <?php include('./includes/header.php'); ?>
</div>
<div id="web">
<div id="cabeza">
    <div id="rank">
        <div id="hh1"><h1>Biografía, historia y legado musical de <?= htmlspecialchars($nombreArtista, ENT_QUOTES, 'UTF-8') ?> <?= htmlspecialchars($anio, ENT_QUOTES, 'UTF-8') ?></h1></div>
    </div>
    <div class="texto1">
        <b>Descubre la música que te apasiona.</b> Sumérgete en un universo de <b>géneros musicales,</b> desde los clásicos que marcaron historia hasta las últimas tendencias que te sorprenderán. Aprende sobre su evolución, descubre nuevos talentos y artistas emergentes, y comparte tu pasión con nuestra comunidad de amantes de la música.
    </div>
    <div class="movil3" id="catsSug">
        <a href="/" title="Inicio">Inicio</a>
        <a href="/top/" title="Top">Top</a>
        <a href="/cumbia-pop/" title="Cumbia Pop">Cumbia Pop</a>
        <a href="/bachatas/" title="Bachata">Bachata</a>
        <a href="/pop/" title="Pop">Pop</a>
        <a href="/musica-cristiana/" title="Musica Cristiana">Musica Cristiana</a>
        <a href="/reggaeton/" title="Reggaeton">Reggaeton</a>
        <a href="/baladas/" title="Baladas">Baladas</a>
        <a href="/alternativo/" title="Alternativo">Alternativo</a>
        <a href="/electronica/" title="Electrónica">Electrónica</a>
        <a href="/cumbias/" title="Cumbias">Cumbias</a>
    </div>
    <ul class="lista-top">
        <?php include('./includes/destacados.php'); ?>
    </ul>
</div>
<div id="cuerpo">
<div class="bloque bioizquierda">
    <div class="biocompleto">

    <center style="margin: 0px 0px 10px 0px;">
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533"
     crossorigin="anonymous"></script>
<!-- PlusM-Horizo -->
<ins class="adsbygoogle"
     style="display:block"
     data-ad-client="ca-pub-7156629532314533"
     data-ad-slot="1648681134"
     data-ad-format="auto"
     data-full-width-responsive="true"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>
    </center>
    <div id="migabiografia">
        <a href="/" title="INICIO">INICIO</a> 
        <a href="/biografias/" title="Biografías">Biografías</a> 
        <a class="active" href="/biografia/<?= htmlspecialchars($artista, ENT_QUOTES, 'UTF-8') ?>" title="Biografías de <?= htmlspecialchars($nombreArtista, ENT_QUOTES, 'UTF-8') ?>"><?= htmlspecialchars($nombreArtista, ENT_QUOTES, 'UTF-8') ?></a>
    </div>
<div class="titulo-biografia">✏ Biografía de <?= htmlspecialchars($nombreArtista, ENT_QUOTES, 'UTF-8') ?></div>
<img class="cover" src="https://tse2.mm.bing.net/th?q=<?= htmlspecialchars($artista, ENT_QUOTES, 'UTF-8') ?>+cantante&w=160&h=160&c=7&rs=1&..." alt="Biografia <?= htmlspecialchars($nombreArtista, ENT_QUOTES, 'UTF-8') ?>">

<?php
// Conexión a la base de datos
$conn = getDBConnection();

// Verificar si el parámetro `query` se recibió correctamente desde la URL
$artista = isset($_GET['query']) ? $_GET['query'] : '';

if (empty($artista)) {
    exit();  // Detener la ejecución si no se recibe el query
}

// Limpieza del nombre del artista
$nombre_real_artista = limpiar_texto($artista);

// Verificar si el artista existe en la tabla `artistas` y tiene músicas
$sql_music = "SELECT genero FROM artistas WHERE artista = ?";
$stmt_music = $conn->prepare($sql_music);

if ($stmt_music === false) {
    exit();  // Detener la ejecución si la consulta no se puede preparar
}

$stmt_music->bind_param("s", $nombre_real_artista);
$stmt_music->execute();
$result_music = $stmt_music->get_result();

if ($result_music->num_rows > 0) {
    // Si se encuentra el artista en la tabla `artistas`, se obtiene el género para formar la URL
    $row_music = $result_music->fetch_assoc();
    $genero = limpiar_url($row_music['genero']);  // Limpia el nombre del género para URL
    $artista_url = limpiar_url($nombre_real_artista);  // Limpia el nombre del artista para URL

    // Mostrar el botón para escuchar músicas
    echo '<div class="btescucha">';
    echo '<a href="/' . $genero . '/' . $artista_url . '/" class="bt bt-ouvir">Escuchar músicas</a>';
    echo '</div>';
}

$stmt_music->close();
$conn->close();
?>




 <?php

// Conexión a la base de datos
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar la conexión
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

// Obtén el nombre del artista desde la URL
$artista = isset($_GET['query']) ? $_GET['query'] : '';

if (empty($artista)) {
    die("No se ha proporcionado un artista.");
}

// Limpia el nombre del artista y genera el enlace
$link_bioartista = strtolower(str_replace(' ', '-', preg_replace('/[^A-Za-z0-9\-]/', '', $artista)));

// Verifica si el artista existe en la tabla `biografias`
$sql = "SELECT id, artista, biografia, num_visitas FROM biografias WHERE artista = ? OR link_bioartista = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $artista, $link_bioartista);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $biografia_id = $row['id'];
    $nombre_real_artista = $row['artista'];  // Nombre del artista en la BD
    $biografia = $row['biografia'];  // Biografía del artista en la BD
    $num_visitas = $row['num_visitas'];  // Número de visitas actual

    // Incrementar el número de visitas
    $num_visitas++;
    $sql_update_visitas = "UPDATE biografias SET num_visitas = ? WHERE id = ?";
    $stmt_update = $conn->prepare($sql_update_visitas);
    $stmt_update->bind_param("ii", $num_visitas, $biografia_id);
    $stmt_update->execute();

    // Ahora busca si existen detalles del artista en la tabla `biografias_detalles`
    $sql_detalles = "SELECT COUNT(*) as count FROM biografias_detalles WHERE biografia_id = ?";
    $stmt_detalles = $conn->prepare($sql_detalles);
    $stmt_detalles->bind_param("i", $biografia_id);
    $stmt_detalles->execute();
    $detalles_result = $stmt_detalles->get_result();
    $detalles_count = $detalles_result->fetch_assoc()['count'];

    if ($detalles_count > 0) {
        // Mostrar biografía desde la BD
		//echo "<img class='cover' src='https://tse2.mm.bing.net/th?q=" . urlencode($artista) . "+artista&w=160&h=160&c=7&rs=1&...' alt='Biografia $nombreArtista'><h2>Biografía de $nombre_real_artista</h2>";
        echo "<div id='biografia'>";
        echo $biografia;
        echo "</div>";
    } else {
        // Ejecuta el script de recopilación ya que faltan detalles
        include('recopilar_informacion.php');
    }
} else {
    // Ejecuta el script de recopilación si no existe la biografía
    include('recopilar_informacion.php');
}

$conn->close();
?>

    <!-- Biografía--->
    </div>
</div>
<div class="bloque derechab">

    <?php
    $conn = getDBConnection();

    // Verifica si el artista existe en la tabla `biografias`
    $sql = "SELECT id, artista FROM biografias WHERE artista = ? OR link_bioartista = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $artista, $link_bioartista);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $biografia_id = $row['id'];
        $nombre_real_artista = $row['artista'];  // Nombre del artista en la BD

        // Busca los detalles del artista en la tabla `biografias_detalles`
        $sql_detalles = "SELECT campo, valor FROM biografias_detalles WHERE biografia_id = ?";
        $stmt_detalles = $conn->prepare($sql_detalles);
        $stmt_detalles->bind_param("i", $biografia_id);
        $stmt_detalles->execute();
        $detalles_result = $stmt_detalles->get_result();

        if ($detalles_result->num_rows > 0) {
            echo "<div id='datosartis'>";
            echo "<h2>Datos de $nombre_real_artista</h2><ul>";
            $redes_sociales = []; // Array para almacenar las redes sociales

            while ($detalle = $detalles_result->fetch_assoc()) {
                $campo = htmlspecialchars($detalle['campo'], ENT_QUOTES, 'UTF-8');
                $valor = htmlspecialchars($detalle['valor'], ENT_QUOTES, 'UTF-8');

                // Verificar si el campo es una red social
                if (in_array($campo, ['Facebook', 'Twitter', 'Instagram', 'YouTube', 'Spotify', 'X', 'iTunes', 'Deezer', 'Apple Music', 'SoundCloud', 'YouTube Music', 'Google Play', 'Pinterest', 'TikTok'])) {
                    $redes_sociales[$campo] = $valor;
                } elseif ($campo == 'Página Oficial') {
					if (!preg_match('/^https?:\/\//', $valor)) {
                    $urlpagina = 'https://' . ltrim($valor); // Añadir 'https://' si no está presente
                        }
                    echo "<li><strong>$campo:</strong> <span><a href='$urlpagina' target='_blank' rel='noopener noreferrer'>$valor</a></span></li>";
                } else {
                    echo "<li><strong>$campo:</strong> <span>$valor</span></li>";
                }
            }

            // Mostrar las redes sociales
            if (!empty($redes_sociales)) {
                echo "<li><strong>Redes Sociales:</strong><ul class='social-links'>";
                foreach ($redes_sociales as $red => $url) {
                    echo "<li><a href='$url' target='_blank' rel='noopener noreferrer'>$red</a></li>";
                }
                echo "</ul></li>";
            }

            echo "</ul></div>";
        } else {
            echo "No se encontraron detalles del artista $nombre_real_artista.";
        }
    } else {
        echo "No se encontró la biografía del artista $artista.";
    }

    $conn->close();
    ?>

    <div class="frames">
        <div style="display: block; text-align: center; color: #999 !important; font-size: 0.6rem; line-height: 2; margin-top: -5px;">ANUNCIOS PUBLICITARIOS</div>
        <div class="top-derecha"></div>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533"
     crossorigin="anonymous"></script>
<!-- PlusM-Vertical -->
<ins class="adsbygoogle"
     style="display:block"
     data-ad-client="ca-pub-7156629532314533"
     data-ad-slot="4997447946"
     data-ad-format="auto"
     data-full-width-responsive="true"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>

        <!-- Aquí puedes agregar contenido adicional o anuncios -->
    </div>

    <?php
    $conn = getDBConnection();

    // Obtener el ID del artista actual
    $artista_id = isset($biografia_id) ? intval($biografia_id) : 0;

    if ($artista_id > 0) {
        // Obtener los géneros del artista actual
        $sql_generos = "SELECT valor FROM biografias_detalles WHERE biografia_id = ? AND campo = 'Género(s)'";
        $stmt_generos = $conn->prepare($sql_generos);
        $stmt_generos->bind_param("i", $artista_id);
        $stmt_generos->execute();
        $result_generos = $stmt_generos->get_result();

        if ($result_generos->num_rows > 0) {
            $generos_row = $result_generos->fetch_assoc();
            $generos = explode(',', $generos_row['valor']); // Dividir géneros en un array

            // Array para almacenar artistas similares
            $artistas_similares = [];

            // Intentar encontrar artistas similares basado en cada género
            foreach ($generos as $genero) {
                $genero = trim($genero);

                // Buscar artistas con el mismo género, excluyendo el artista actual
                $sql_similares = "SELECT DISTINCT b.id, b.artista, b.link_bioartista 
                                  FROM biografias b
                                  JOIN biografias_detalles d ON b.id = d.biografia_id
                                  WHERE d.campo = 'Género(s)' AND d.valor LIKE ? AND b.id != ? 
                                  ORDER BY RAND() LIMIT 8";
                $stmt_similares = $conn->prepare($sql_similares);
                $like_genero = "%" . $genero . "%";
                $stmt_similares->bind_param("si", $like_genero, $artista_id);
                $stmt_similares->execute();
                $result_similares = $stmt_similares->get_result();

                while ($row_similar = $result_similares->fetch_assoc()) {
                    if (count($artistas_similares) < 8) {
                        $artistas_similares[] = $row_similar;
                    }
                }

                if (count($artistas_similares) >= 8) {
                    break; // Ya tenemos 8 artistas similares, no necesitamos más
                }
            }

            // Mostrar los artistas similares
            if (count($artistas_similares) > 0) {
                echo "<div class='artisimilar'>";
                echo "<h3>Artistas similares a {$nombre_real_artista}</h3><div class='similares-container'>";
                foreach ($artistas_similares as $artista_similar) {
                    echo "<div class='similares-item'>";
                    echo "<a href='/{$artista_similar['link_bioartista']}/biografia'>";
                    echo "<img src='https://tse2.mm.bing.net/th?q=" . urlencode($artista_similar['artista']) . "+artista&w=80&h=80&c=7&rs=1&...' alt='{$artista_similar['artista']}'>";
                    echo "<p>{$artista_similar['artista']}</p>";
                    echo "</a>";
                    echo "</div>";
                }
                echo "</div></div>";
            } else {
                echo "<p>No se encontraron artistas similares.</p>";
            }
        } else {
            echo "<p>No se encontraron géneros para este artista.</p>";
        }

        $stmt_generos->close();
    }

    $conn->close();
    ?>
    
</div>

</div>
<img src="https://wvw.plusmusicas.com/img/top-arrb.png" id="backToTopBtn" alt="Volver arriba" title="Volver arriba">
<script type="text/javascript">
// Obtener el botón
var mybutton = document.getElementById("backToTopBtn");

// Mostrar el botón cuando el usuario baja 100px desde la parte superior del documento
window.onscroll = function() {scrollFunction()};

function scrollFunction() {
    if (document.body.scrollTop > 1000 || document.documentElement.scrollTop > 1000) {
        mybutton.style.display = "block";
    } else {
        mybutton.style.display = "none";
    }
}

// Cuando el usuario hace clic en el botón, vuelve a la parte superior del documento con un desplazamiento suave
mybutton.onclick = function() {
    window.scrollTo({
        top: 0,
        behavior: 'smooth' // Desplazamiento suave
    });
}
</script>
<div id="pie">
    <ul class="lista-abc">
        <?php include('./includes/abc.php'); ?>
    </ul>
</div>
<div id="pie">
    <?php include('./includes/pie.php'); ?>
</div>
</div>

</div></span></div></div>
</body>
</html>