<?php
/* Datos Web */
$sitename = "PlusMusicas";

/* Configuración BD */
$root = "https://wvw.plusmusicas.com";

// Conexión a la base de datos
$db_host = 'localhost';
$db_user = 'plusmusi_owner';
$db_pass = '^@#F-NBx3W}+';
$db_name = 'plusmusi_data';

try {
    $conectar = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conectar->connect_error) {
        throw new Exception("Error de conexión: " . $conectar->connect_error);
    }
    $conectar->set_charset("utf8mb4");
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
    exit();
}

/* Configuración Opcional */
$anio = "2024"; // Año que irá en los títulos

// Funciones de limpieza de texto y URL
function limpiar($cadena) {
    return ucwords(str_replace('-', ' ', str_replace('_', '-', $cadena)));
}

function limpiar_url($cadena) {
    return strtolower(str_replace(' ', '-', $cadena));
}

function limpiar_titulo($cadena) {
    return htmlspecialchars(trim(str_replace(array('&', 'ñ', '_', '"', "'"), array('Y', 'n', ' ', '', ''), $cadena)));
}

function limpiar_texto($cadena) {
    return limpiar(htmlspecialchars(preg_replace("/[^A-Za-z0-9]/", " ", $cadena)));
}

// Obtén el nombre del artista desde la URL
$artista = isset($_GET['query']) ? $_GET['query'] : '';
if (empty($artista)) {
    $bus = array("Bad Bunny", "Dyland y Lenny", "Plan B", "La Factoria", "Chino y Nacho", "Don Omar", "Rio Roma", "Chapa C", "Daddy Yankee", "Arcangel", "Wisin Y Yandel", "Corazon Serrano");
    $artista = $bus[array_rand($bus)];
}

// Limpia el nombre del artista
$nombreArtista = limpiar_texto($artista);

// Metadatos de la página
$title = "Biografías Completas y Letras de Canciones de los Mejores Artistas - $sitename";
$description = "Explora las biografías completas y las letras de las canciones de tus artistas favoritos. Descubre la historia, el legado y las letras de canciones de artistas como The Beatles, Taylor Swift, The Rolling Stones y muchos más en $sitename. Sumérgete en un universo musical y conecta con la pasión detrás de cada artista.";
$keyword = "biografías de artistas, letras de canciones, música, The Beatles, Taylor Swift, The Rolling Stones, biografía completa, historia de la música, legado musical, artistas destacados, $sitename";
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=$title?></title>
    <meta name="description" content="<?=$description?>" />
    <meta name="keywords" content="<?=$keyword?>" />
    <meta property="og:title" content="<?=$title?>" />
    <meta property="og:description" content="<?=$description?>" />
    <meta property="og:image" content="https://wvw.plusmusicas.com/img/bannerplus.jpg" />
    <meta property="og:url" content="<?= $root ?>/" />
    <meta property="og:type" content="website" />
    <meta property="og:site_name" content="<?=$sitename?>" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="<?=$title?>" />
    <meta name="twitter:description" content="<?=$description?>" />
    <meta name="twitter:image" content="https://wvw.plusmusicas.com/img/bannerplus.jpg" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta http-equiv="Content-Language" content="es" />
    <meta name="robots" content="index, follow" />
    <meta name="googlebot" content="index, follow" />
    <meta name="copyright" content="<?=$sitename?> - Derechos Reservados" />
    <meta name="revisit-after" content="1 day" />
    <link rel="stylesheet" type="text/css" href="/css/plusmST2.css?v=1.2" />
    <link rel="stylesheet" type="text/css" href="<?=$root?>/css/movil.css?v=1.2" />
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533" crossorigin="anonymous"></script>
</head>
<body>
<div id="header">
    <?php include('./includes/header.php');?>
</div>
<div id="web">
    <div id="cabeza">
        <div id="rank">
            <div id="hh1"><h1>Biografía, historia y legado musical de <?=$nombreArtista?> <?=$anio?></h1></div>
        </div>
        <div class="texto1">
            <b>Descubre la música que te apasiona.</b> Sumérgete en un universo de <b>géneros musicales,</b> desde los clásicos que marcaron historia hasta las últimas tendencias que te sorprenderán. Aprende sobre su evolución, descubre nuevos talentos y artistas emergentes, y comparte tu pasión con nuestra comunidad de amantes de la música.
        </div>
        <div class="movil3" id="catsSug">
            <a href="/" title="Inicio">Inicio</a>
            <a href="/top/" title="Top">Top</a>
            <a href="/cumbia-pop/" title="Cumbia Pop">Cumbia Pop</a>
            <a href="/bachatas/" title="Bachata">Bachata</a>
            <a href="/pop/" title="Pop">Pop</a>
            <a href="/musica-cristiana/" title="Musica Cristiana">Musica Cristiana</a>
            <a href="/reggaeton/" title="Reggaeton">Reggaeton</a>
            <a href="/baladas/" title="Baladas">Baladas</a>
            <a href="/alternativo/" title="Alternativo">Alternativo</a>
            <a href="/electronica/" title="Electrónica">Electrónica</a>
            <a href="/cumbias/" title="Cumbias">Cumbias</a>
        </div>
    </div>
    <div id="cuerpo">
        <div class="container">
            <div class="overlay"></div>
            <div class="content">
                <h1>Biografías de los Mejores Músicos del Mundo</h1>
                <form method="get" action="<?= $root ?>/search.php" name="qy">
                    <div class="search-box">
                        <input type="text" name="q" id="search-input" placeholder="Buscar biografías de artistas" autocomplete="off">
                        <button type="submit">Buscar</button>
                    </div>
                    <div id="search-results" class="search-results scroling"></div>
                </form>
            </div>
        </div>

        <!-- Sección de Artistas Destacados -->
        <?php
        // Consultar los 7 artistas más visitados
        $sql = "SELECT artista, link_bioartista FROM biografias ORDER BY num_visitas DESC LIMIT 7";
        $result = $conectar->query($sql);

        if ($result->num_rows > 0) {
            echo '<div class="featured-artists">
                    <h2>Artistas Destacados</h2>
                    <div class="artist-grid">';
            
            while($row = $result->fetch_assoc()) {
                $artista = $row['artista'];
                $link_bioartista = $row['link_bioartista'];
                
                echo '<div class="artist-item">
                        <a href="/biografia/' . $link_bioartista . '">
                            <img src="https://tse2.mm.bing.net/th?q=' . urlencode($artista) . '+artista&w=190&h=190&c=7&rs=1?.jpg" alt="Foto de ' . htmlspecialchars($artista) . '" title="Biografía de ' . htmlspecialchars($artista) . '">
                            <p>' . htmlspecialchars($artista) . '</p>
                        </a>
                      </div>';
            }
            
            echo '  </div>
                </div>';
        } else {
            echo "No se encontraron artistas.";
        }
        ?>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533"
     crossorigin="anonymous"></script>
<ins class="adsbygoogle"
     style="display:inline-block;width:1000px;height:360px"
     data-ad-client="ca-pub-7156629532314533"
     data-ad-slot="8557467399"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>
        <!-- Sección de Biografías Agregadas -->
        <?php
        // Consultar las 5 últimas biografías agregadas
        $sql = "SELECT id, artista, link_bioartista, biografia, fecha_publicacion FROM biografias ORDER BY id DESC LIMIT 10";
        $result = $conectar->query($sql);

        if ($result->num_rows > 0) {
            echo '<div class="latest-news">
                    <h2>Últimas Biografías Agregadas</h2>
                    <div id="biografias-container">';
            
            while($row = $result->fetch_assoc()) {
                $artista = $row['artista'];
                $link_bioartista = $row['link_bioartista'];
                $biografia = $row['biografia'];
                
                // Remover la pregunta inicial "¿Qué se sabe de ..."
                $biografia = preg_replace('/<h2>¿Qué se sabe de .*?<\/h2>/i', '', $biografia);

                // Formatear la fecha correctamente
                setlocale(LC_TIME, 'es_ES.UTF-8');
                $fecha_publicacion = strftime("%d de %B, %Y", strtotime($row['fecha_publicacion']));
                
                echo '<div class="news-item">
                        <div class="news-content">
                            <p class="news-date">' . $fecha_publicacion . '</p>
                            <a href="/biografia/' . $link_bioartista . '"><h3>Biografía de ' . htmlspecialchars($artista) . '</h3></a>
                            <p>' . htmlspecialchars(strip_tags(substr($biografia, 0, 200))) . '...</p>
                        </div>
                        <div class="news-image">
                            <a href="/biografia/' . $link_bioartista . '">
                                <img src="https://tse2.mm.bing.net/th?q=' . urlencode($artista) . '+artista&w=300&h=150&c=7&rs=1?.jpg" alt="Foto de ' . htmlspecialchars($artista) . '" title="Biografía de ' . htmlspecialchars($artista) . '">
                            </a>
                        </div>
                    </div>';
            }
            
            echo '</div>';
            
            // Botón para cargar más biografías
            echo '<button id="load-more" data-offset="10">Leer más biografías</button>';
            echo '</div>';
        } else {
            echo "No se encontraron biografías.";
        }
        ?>

        <!-- Scripts para la carga dinámica de biografías -->
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script>
        $(document).ready(function(){
            $('#search-input').on('input', function(){
                var query = $(this).val();
                if(query.length > 2) {
                    $.ajax({
                        url: '/includes/search_autocomplete.php',
                        method: 'GET',
                        data: {query: query},
                        success: function(data) {
                            $('#search-results').html(data).show();
                        }
                    });
                } else {
                    $('#search-results').hide();
                }
            });

            // Hide the result list if the user clicks outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('.search-box').length) {
                    $('#search-results').hide();
                }
            });

            // Redirigir al hacer clic en un elemento de la lista
            $(document).on('click', '.search-results li', function(){
                var artistLink = $(this).data('link'); // Obtener el enlace de la biografía del atributo data-link
                window.location.href = artistLink; // Redirigir a la biografía
            });

            // Función para cargar más biografías
            $('#load-more').on('click', function(){
                var offset = $(this).data('offset');
                
                $.ajax({
                    url: '/includes/load_more_biografias.php',
                    type: 'GET',
                    data: {
                        offset: offset
                    },
                    success: function(data){
                        // Agregar nuevas biografías al contenedor
                        if (data.trim() !== '') {
                            $('#biografias-container').append(data);
                            $('#load-more').data('offset', offset + 10);
                        } else {
                            $('#load-more').hide(); // O puedes cambiarlo a disabled o mostrar un mensaje "No hay más biografías"
                        }
                    },
                    error: function(){
                        alert('No se pudieron cargar más biografías');
                    }
                });
            });
        });
        </script>

        <div class="bloque bioizquierda">
            <div class="biocompleto">
                <center style="margin: 0px 0px 10px 0px;">
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533"
     crossorigin="anonymous"></script>
<!-- PlusM-1 -->
<ins class="adsbygoogle"
     style="display:inline-block;width:620px;height:280px"
     data-ad-client="ca-pub-7156629532314533"
     data-ad-slot="3915514809"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>
                </center>
                <?php
                // Si no se encuentra la biografía, muestra el mensaje alternativo
                echo "<p>¿Quieres escuchar la música de <b>$nombreArtista</b> en línea? ¡Has llegado al lugar indicado! Nuestro sitio web de música en línea te permite disfrutar de las últimas canciones de $nombreArtista y otros artistas destacados. Aunque lamentablemente no contamos con una biografía para $nombreArtista en este momento, aún puedes descubrir y revivir tus canciones favoritas. Escucha música en línea de manera ilimitada, en cualquier momento y lugar de tu elección. Únete a nuestra comunidad en línea y experimenta la mejor música del año $anio.</p>";
                ?>
            </div>
        </div>
        <div class="bloque derechab">
            <!-- anuncio 300x250-->
            <div style="display: block;text-align: center;color: #999 !important;font-size: 0.6rem;line-height: 2;/* margin-top: -5px; */">ANUNCIOS PUBLICITARIOS</div>
            <div class="frames"></div>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533"
     crossorigin="anonymous"></script>
<!-- PlusM-2 -->
<ins class="adsbygoogle"
     style="display:block;height:280px"
     data-ad-client="ca-pub-7156629532314533"
     data-ad-slot="5519643382"
     data-ad-format="auto"
     data-full-width-responsive="true"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>
        </div>
    </div>
    <div id="pie">
        <ul class="lista-abc">
            <?php include('./includes/abc.php');?>
        </ul>
    </div>
    <div id="pie">
        <?php include('./includes/pie.php');?>
    </div>
</div>
</body>
</html>
