<?php
// Conexión a la base de datos
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar la conexión
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Establecer el conjunto de caracteres a utf8mb4
$conn->set_charset("utf8mb4");

// Obtener los datos enviados desde el script de JavaScript
$artista = isset($_POST['artista']) ? trim($_POST['artista']) : '';
$biografia = isset($_POST['biografia']) ? trim($_POST['biografia']) : '';

// Generar el enlace limpio para `link_bioartista`
$link_bioartista = strtolower(str_replace(' ', '-', preg_replace('/[^A-Za-z0-9 ]/', '', $artista)));

if (!empty($artista) && !empty($biografia)) {

    // Modificar los enlaces en la biografía
    $biografia = preg_replace_callback('/<a href="([^"]*)"(.*?)>(.*?)<\/a>/i', function($matches) {
        $url = $matches[1];
        $attributes = $matches[2];
        $linkText = $matches[3];

        // Verificar si es un enlace a una canción o video
        if (strpos($url, '/cancion/') !== false || strpos($url, '/video/') !== false) {
            return "<em>$linkText</em>";
        } elseif (strpos($url, 'buenamusica.com') !== false) {
            // Eliminar el dominio y asegurar que comience con un solo "/"
            $newUrl = preg_replace('/https?:\/\/(www\.)?buenamusica\.com\//', '', $url);
        } else {
            $newUrl = $url;
        }

        // Asegurar que todos los enlaces sean del formato "/artista/biografia"
        $newUrl = rtrim($newUrl, '/'); // Eliminar cualquier barra al final
        if (strpos($newUrl, 'biografia') === false) {
            $newUrl .= '/biografia';
        }

        // Asegurar que el enlace comience con "/"
        $newUrl = '/' . ltrim($newUrl, '/');

        return '<a href="' . htmlspecialchars($newUrl) . '"' . $attributes . '>' . htmlspecialchars($linkText) . '</a>';
    }, $biografia);

    // Reemplazar <h2>¿Quién es con <h2>¿Qué se sabe de
    $biografia = str_replace('<h2>¿Quién es', '<h2>¿Qué se sabe de', $biografia);

    // Verificar si ya existe una biografía para este artista
    $sql_check = "SELECT id FROM biografias WHERE artista = ? OR link_bioartista = ?";
    $stmt_check = $conn->prepare($sql_check);
    $stmt_check->bind_param('ss', $artista, $link_bioartista);
    $stmt_check->execute();
    $result = $stmt_check->get_result();

    if ($result->num_rows > 0) {
        echo "La biografía ya existe en la base de datos.";
    } else {
        // Guardar la biografía en la base de datos con fecha_publicacion
        $sql = "INSERT INTO biografias (artista, biografia, link_bioartista, fecha_publicacion) VALUES (?, ?, ?, NOW())";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('sss', $artista, $biografia, $link_bioartista);

        if ($stmt->execute()) {
            echo "Biografía guardada correctamente.";
        } else {
            echo "Error al guardar la biografía: " . $stmt->error;
        }

        $stmt->close();
    }

    $stmt_check->close();
} else {
    echo "Datos inválidos.";
}

$conn->close();
?>
