<?php
// Conexión a la base de datos
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar la conexión
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Establecer el conjunto de caracteres a utf8mb4
$conn->set_charset("utf8mb4");

// Obtener los datos enviados desde el script de JavaScript
$artista = isset($_POST['artista']) ? trim($_POST['artista']) : '';
$datos_artista = isset($_POST['datos_artista']) ? trim($_POST['datos_artista']) : '';

if (!empty($artista) && !empty($datos_artista)) {
    // Obtener el ID de la biografía del artista usando sentencias preparadas
    $sql = "SELECT id FROM biografias WHERE artista = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $artista);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $biografia_id = $row['id'];

        // Procesar los datos del artista
        $dom = new DOMDocument('1.0', 'UTF-8');
        @$dom->loadHTML('<?xml encoding="UTF-8">' . $datos_artista);
        $items = $dom->getElementsByTagName('li');

        foreach ($items as $item) {
            $campoElement = $item->getElementsByTagName('strong')->item(0);
            $valorElement = $item->getElementsByTagName('span')->item(0);

            if ($campoElement && $valorElement) {
                $campo = trim($campoElement->textContent, ':');
                $valor = $valorElement->textContent;

                // Si es un campo de redes sociales, obtener las URLs también
                if (strtolower($campo) == 'redes sociales') {
                    $links = $valorElement->getElementsByTagName('a');
                    foreach ($links as $link) {
                        $url = $link->getAttribute('href');
                        $redSocial = $link->textContent;

                        // Verificar si ya existe este campo en la base de datos
                        $sql_check = "SELECT id FROM biografias_detalles WHERE biografia_id = ? AND campo = ?";
                        $stmt_check = $conn->prepare($sql_check);
                        $stmt_check->bind_param('is', $biografia_id, $redSocial);
                        $stmt_check->execute();
                        $check_result = $stmt_check->get_result();

                        if ($check_result->num_rows == 0) {
                            // Insertar el nombre de la red social y su URL usando sentencias preparadas
                            $sql_insert = "INSERT INTO biografias_detalles (biografia_id, campo, valor) VALUES (?, ?, ?)";
                            $stmt_insert = $conn->prepare($sql_insert);
                            $stmt_insert->bind_param('iss', $biografia_id, $redSocial, $url);

                            if (!$stmt_insert->execute()) {
                                echo "Error al guardar los detalles del artista: " . $stmt_insert->error;
                            }

                            $stmt_insert->close();
                        }

                        $stmt_check->close();
                    }
                } else {
                    // Verificar si el campo ya existe
                    $sql_check = "SELECT id FROM biografias_detalles WHERE biografia_id = ? AND campo = ?";
                    $stmt_check = $conn->prepare($sql_check);
                    $stmt_check->bind_param('is', $biografia_id, $campo);
                    $stmt_check->execute();
                    $check_result = $stmt_check->get_result();

                    if ($check_result->num_rows == 0) {
                        // Insertar los detalles en la tabla `biografias_detalles` usando sentencias preparadas
                        $sql_insert = "INSERT INTO biografias_detalles (biografia_id, campo, valor) VALUES (?, ?, ?)";
                        $stmt_insert = $conn->prepare($sql_insert);
                        $stmt_insert->bind_param('iss', $biografia_id, $campo, $valor);

                        if (!$stmt_insert->execute()) {
                            echo "Error al guardar los detalles del artista: " . $stmt_insert->error;
                        }

                        $stmt_insert->close();
                    }

                    $stmt_check->close();
                }
            }
        }

        echo "Datos del artista guardados correctamente.";
    } else {
        echo "No se encontró la biografía del artista.";
    }

    $stmt->close();
} else {
    echo "Datos inválidos.";
}

$conn->close();
?>