<?php
$cache_life = 60*60*24*7;
include __DIR__.'/includes/cache.php';
?>
<!doctype html>
<html lang="es-en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Escuchar Música en Línea | PlusMusicas - Lo Mejor en Música Online <?=$anio?></title>
    <meta name="description" content="Escucha y comparte la mejor música en línea gratis en PlusMusicas. Disfruta de tus canciones y artistas favoritos sin límites. Música online <?=$anio?>.">
    <meta name="keywords" content="música en línea, escuchar música gratis, descargar música, playlists, música <?=$anio?>, música online, streaming de música">
    <meta name="author" content="Equipo PlusMusicas">
    <meta name="robots" content="index, follow">
    <meta name="googlebot" content="index, follow">
    <meta property="og:title" content="Escuchar Música en Línea | PlusMusicas - Lo Mejor en Música Online <?=$anio?>">
    <meta property="og:description" content="Escucha y comparte la mejor música en línea gratis en PlusMusicas. Disfruta de tus canciones y artistas favoritos sin límites. Música online <?=$anio?>.">
    <meta property="og:url" content="https://wvw.plusmusicas.com/">
    <meta property="og:site_name" content="PlusMusicas">
    <meta property="og:image" content="https://wvw.plusmusicas.com/img/bannerplus.jpg">
    <meta property="og:type" content="website">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Escuchar Música en Línea | PlusMusicas - Lo Mejor en Música Online <?=$anio?>">
    <meta name="twitter:description" content="Escucha y comparte la mejor música en línea gratis en PlusMusicas. Disfruta de tus canciones y artistas favoritos sin límites. Música online <?=$anio?>.">
    <meta name="twitter:image" content="https://wvw.plusmusicas.com/img/bannerplus.jpg">
    <meta http-equiv="Content-Language" content="es">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="icon" href="favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="/css/estilos.css?v=<?php echo time(); ?>">
    <script rel="nofollow" type="text/javascript" src="<?= $root ?>/js/funciones.js?v=<?php echo time(); ?>"></script>
    <script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebSite",
    "name": "PlusMusicas",
    "url": "https://wvw.plusmusicas.com/",
    "potentialAction": {
"@type": "SearchAction",
"target": "https://wvw.plusmusicas.com/mp3/{search_term_string}/",
"query-input": "required name=search_term_string"
    },
    "inLanguage": "es-ES"
}
    </script>
    <script data-ad-client="ca-pub-7156629532314533" defer src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
</head>
<body>
<div id="header">

  <div id="transp">
    <div id="elog">
      <a title="Top Musicas" href="/top/">
        <div id="logo"></div>
      </a>
      <div id="bus">
      <div id="bu1">
        <div id="x3">
            <form method="get" action="<?= $root ?>/search.php" name="qy">
                <div id="bux">
                    <input type="text" name="q" id="sfrm" placeholder="Buscar canción o artista" />
                </div>
                <div id="hbu">
                    <input type="image" name="sa" src="<?= $root ?>/img/bsc.png" alt="Buscar" />
                </div>
            </form>
        </div>
    </div>
      </div>
      <div id="tow">
        <div id="vemp3">
          <a href="<?= $root ?>/top/" title="TOP MÚSICA">TOP MÚSICA</a>
          <a href="<?= $root ?>/generos/" title="MÁS GÉNEROS">MÁS GÉNEROS</a>
          <a href="<?= $root ?>/varios-artistas/" title="PLAYLIST">PLAYLIST</a>
		  <a class="sugieree" href="https://sugerencias.maxmusicas.com/sugerencias/" rel="nofollow" target="_blank" onclick="window.open('https://sugerencias.maxmusicas.com/sugerencias/', 'Sugerencias', 'width=400,height=620'); return false;">Sugerir ✉</a>

         </div>
      </div>
    </div>
  </div>

</div>
<div class="g-1">


<div class="viewer">
	<div class="paging">
		<a href="#" rel="1">1</a>
		<a href="#" rel="2">2</a>
		<a href="#" rel="3">3</a>
		<a href="#" rel="4">4</a>
		<a href="#" rel="5">5</a>
	</div>
	<div class="slideimages">

<?php

$total = 5;
$img = array(
'<a href="/country/taylor-swift/"><h1>Taylor Swift</h1><div>Escuchar Playlist</div><img alt="Escuchar Taylor Swift" style="" src="./artist/VGF5bG9yIFN3aWZ0.jpg"></a>',
'<a href="/k-pop/bts/"><h1>BTS</h1><div>Escuchar Playlist</div><img alt="Escuchar BTS" style="" src="./artist/QlRT.jpg"></a>',
'<a href="/hip-hop/drake/"><h1>Drake</h1><div>Escuchar Playlist</div><img alt="Escuchar Drake" style="" src="./artist/ZHJha2U=.jpg"></a>',
'<a href="/pop/the-weeknd/"><h1>The Weeknd</h1><div>Escuchar Playlist</div><img alt="Escuchar The Weeknd" style="" src="./artist/VGhlIFdlZWtuZA==.jpg"></a>',
'<a href="/pop-rock/justin-bieber/"><h1>Justin Bieber</h1><div>Escuchar Playlist</div><img alt="Escuchar Justin Bieber" style="" src="./artist/p40f48bb886c65.jpg"></a>',
'<a href="/pop/harry-styles/"><h1>Harry Styles</h1><div>Escuchar Playlist</div><img alt="Escuchar Harry Styles" style="" src="./artist/SGFycnkgU3R5bGVz.jpg"></a>',
'<a href="/pop/billie-eilish/"><h1>Billie Eilish</h1><div>Escuchar Playlist</div><img alt="Escuchar Billie Eilish" style="" src="./artist/QmlsbGllIEVpbGlzaA==.jpg"></a>',
'<a href="/pop/ed-sheeran/"><h1>Ed Sheeran</h1><div>Escuchar Playlist</div><img alt="Escuchar Ed Sheeran" style="" src="./artist/RWQgU2hlZXJhbg==.jpg"></a>',
'<a href="/pop/dua-lipa/"><h1>Dua Lipa</h1><div>Escuchar Playlist</div><img alt="Escuchar Dua Lipa" style="" src="./artist/RHVhIExpcGE=.jpg"></a>',
'<a href="/alternativo/the-1975/"><h1>The 1975</h1><div>Escuchar Playlist</div><img alt="Escuchar The 1975" style="" src="./artist/VGhlIDE5NzU=.jpg"></a>',
'<a href="/reggaeton/bad-bunny/"><h1>Bad Bunny</h1><div>Escuchar Playlist</div><img alt="Escuchar Bad Bunny" style="" src="./artist/QmFkIEJ1bm55.jpg"></a>',
'<a href="/reggaeton/rauw-alejandro/"><h1>Rauw Alejandro</h1><div>Escuchar Playlist</div><img alt="Escuchar Rauw Alejandro" style="" src="./artist/UmF1dyBBbGVqYW5kcm8=.jpg"></a>',
'<a href="/reggaeton/j-balvin/"><h1>J Balvin</h1><div>Escuchar Playlist</div><img alt="Escuchar J Balvin" style="" src="./artist/SiBCYWx2aW4=.jpg"></a>',
'<a href="/reggaeton/karol-g/"><h1>Karol G</h1><div>Escuchar Playlist</div><img alt="Escuchar Karol G" style="" src="./artist/S2Fyb2wgRw==.jpg"></a>',
'<a href="/reggaeton/anuel-aa/"><h1>Anuel AA</h1><div>Escuchar Playlist</div><img alt="Escuchar Anuel AA" style="" src="./artist/QW51ZWwgQUE=.jpg"></a>',
'<a href="/reggaeton/daddy-yankee/"><h1>Daddy Yankee</h1><div>Escuchar Playlist</div><img alt="Escuchar Daddy Yankee" style="" src="./artist/p50f4901c75191.jpg"></a>',
'<a href="/reggaeton/ozuna/"><h1>Ozuna</h1><div>Escuchar Playlist</div><img alt="Escuchar Ozuna" style="" src="./artist/T3p1bmE=.jpg"></a>',
'<a href="/reggaeton/farruko/"><h1>Farruko</h1><div>Escuchar Playlist</div><img alt="Escuchar Farruko" style="" src="./artist/RmFycnVrbw==.jpg"></a>',
'<a href="/reggaeton/maluma/"><h1>Maluma</h1><div>Escuchar Playlist</div><img alt="Escuchar Maluma" style="" src="./artist/TWFsdW1h.jpg"></a>',
'<a href="/pop/sebastian-yatra/"><h1>Sebastián Yatra</h1><div>Escuchar Playlist</div><img alt="Escuchar Sebastián Yatra" style="" src="./artist/U2ViYXN0aWFuIFlhdHJh.jpg"></a>',
'<a href="/pop/olivia-rodrigo/"><h1>Olivia Rodrigo</h1><div>Escuchar Playlist</div><img alt="Escuchar Olivia Rodrigo" style="" src="./artist/T2xpdmlhIFJvZHJpZ28=.jpg"></a>',
'<a href="/pop/maneskin/"><h1>Måneskin</h1><div>Escuchar Playlist</div><img alt="Escuchar Måneskin" style="" src="./artist/TcOlbmVza2lu.jpg"></a>',
'<a href="/alternativo/glass-animals/"><h1>Glass Animals</h1><div>Escuchar Playlist</div><img alt="Escuchar Glass Animals" style="" src="./artist/R2xhc3MgQW5pbWFscw==.jpg"></a>',
'<a href="/hip-hop/the-kid-laroi/"><h1>The Kid Laroi</h1><div>Escuchar Playlist</div><img alt="Escuchar The Kid Laroi" style="" src="./artist/VGhlIEtpZCBMYXJvaQ==.jpg"></a>',
'<a href="/pop/nessa-barrett/"><h1>Nessa Barrett</h1><div>Escuchar Playlist</div><img alt="Escuchar Nessa Barrett" style="" src="./artist/TmVzc2EgQmFycmV0dA==.jpg"></a>',
'<a href="/electronica/skrillex/"><h1>Skrillex</h1><div>Escuchar Playlist</div><img alt="Escuchar Skrillex" style="" src="./artist/p50f4877f3a4df.jpg"></a>',
'<a href="/pop/pinkpantheress/"><h1>PinkPantheress</h1><div>Escuchar Playlist</div><img alt="Escuchar PinkPantheress" style="" src="./artist/UGlua1BhbnRoZXJlc3M=.jpg"></a>',
'<a href="/pop/tai-verdes/"><h1>Tai Verdes</h1><div>Escuchar Playlist</div><img alt="Escuchar Tai Verdes" style="" src="./artist/VGFpIFZlcmRlcw==.jpg"></a>',
'<a href="/pop/conan-gray/"><h1>Conan Gray</h1><div>Escuchar Playlist</div><img alt="Escuchar Conan Gray" style="" src="./artist/Q29uYW4gR3JheQ==.jpg"></a>',
'<a href="/ryb/arlo-parks/"><h1>Arlo Parks</h1><div>Escuchar Playlist</div><img alt="Escuchar Arlo Parks" style="" src="./artist/QXJsbyBQYXJrcw==.jpg"></a>',
'<a href="/rap/ptazeta/"><h1>Ptazeta</h1><div>Escuchar Playlist</div><img alt="Escuchar Ptazeta" style="" src="./artist/UHRhemV0YQ==.jpg"></a>',
'<a href="/rap/nicki-nicole/"><h1>Nicki Nicole</h1><div>Escuchar Playlist</div><img alt="Escuchar Nicki Nicole" style="" src="./artist/Tmlja2kgTmljb2xl.jpg"></a>',
'<a href="/trap/bizarrap/"><h1>Bizarrap</h1><div>Escuchar Playlist</div><img alt="Escuchar Bizarrap" style="" src="./artist/Qml6YXJyYXA=.jpg"></a>',
'<a href="/pop/maria-becerra/"><h1>María Becerra</h1><div>Escuchar Playlist</div><img alt="Escuchar María Becerra" style="" src="./artist/TWFyw61hIEJlY2VycmE=.jpg"></a>',
'<a href="/rap/trueno/"><h1>Trueno</h1><div>Escuchar Playlist</div><img alt="Escuchar Trueno" style="" src="./artist/VHJ1ZW5v.jpg"></a>',
'<a href="/pop/lorde/"><h1>Lorde</h1><div>Escuchar Playlist</div><img alt="Escuchar Lorde" style="" src="./artist/TG9yZGU=.jpg"></a>',
'<a href="/reggaeton/rels-b/"><h1>Rels B</h1><div>Escuchar Playlist</div><img alt="Escuchar Rels B" style="" src="./artist/UmVscyBC.jpg"></a>',
'<a href="/rap/paula-cendejas/"><h1>Paula Cendejas</h1><div>Escuchar Playlist</div><img alt="Escuchar Paula Cendejas" style="" src="./artist/UGF1bGEgQ2VuZGVqYXM=.jpg"></a>',
'<a href="/reggaeton/dylan-fuentes/"><h1>Dylan Fuentes</h1><div>Escuchar Playlist</div><img alt="Escuchar Dylan Fuentes" style="" src="./artist/RHlsYW4gRnVlbnRlcw==.jpg"></a>',
'<a href="/pop/juan-pablo-vega/"><h1>Juan Pablo Vega</h1><div>Escuchar Playlist</div><img alt="Escuchar Juan Pablo Vega" style="" src="./artist/SnVhbiBQYWJsbyBWZWdh.jpg"></a>'
);

shuffle($img);

for($i = 0;$i< $total;$i++){
$html .= $img[$i]."\n";
}

echo $html;

?>
</div>
</div>


</div>
<hr class="line">
<div class="g-1 g-mb g-pr">
    <h2 class="h1"><a href="/varios-artistas/">Listas de Varios Artistas</a></h2>
    <a href="/varios-artistas/" class="cnt-more">Ver más →</a>
 <div class="g-fix g-mb tile--large">
<?php
// Realiza la conexión a tu base de datos (reemplaza con tus propios datos de conexión)
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verifica la conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Consulta para obtener 4 artistas aleatorios del género "Varios Artistas"
$sql = "SELECT DISTINCT artista, COUNT(cancion) as num_canciones FROM canciones WHERE genero = 'Varios Artistas' GROUP BY artista ORDER BY RAND() LIMIT 4";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Mostrar los artistas y la cantidad de canciones de cada uno
    while ($row = $result->fetch_assoc()) {
$artistSlug = strtolower(str_replace(' ', '-', $row['artista']));

echo "<a href='/varios-artistas/{$artistSlug}/' class='tile g-1-4'>";
echo "<i>";
echo "<img src='https://tse2.mm.bing.net/th?q={$artistSlug}&w=245&h=137&c=7&rs=1' alt='Escuchar {$row['artista']}' width='245' height='auto'>";
echo "</i>";
echo "<b title='{$row['artista']}'>{$row['artista']}</b>";
echo "<span>{$row['num_canciones']} Canciones online</span>";
echo "</a>";
    }
} else {
    echo "No se encontraron artistas de Varios Artistas.";
}

// Cierra la conexión a la base de datos
$conn->close();
?>
    </div>
</div>

 
<hr class="line">
<section class="fulltxt g-1 g-mb">
    <div>
        <h2>Explora la Mejor Música en PlusMusicas</h2>
        <p>En PlusMusicas, te ofrecemos una experiencia musical online inigualable. Sumérgete en nuestra vasta colección de canciones y descubre artistas de renombre en una amplia variedad de géneros. Con PlusMusicas, tu experiencia auditiva se eleva a nuevas alturas, con una diversidad y calidad que te sorprenderán.</p>
        
        <h3>Géneros Musicales que Te Encantarán</h3>
        <p>En PlusMusicas, tenemos algo para todos los gustos, con una selección que abarca:</p>
        <ul>
            <li><strong>Rock:</strong> Desde los himnos clásicos hasta las últimas tendencias, explora lo mejor del rock.</li>
            <li><strong>Reggaeton:</strong> Siente la energía de los ritmos más vibrantes del reggaeton.</li>
            <li><strong>Sertanejo:</strong> Descubre a los artistas más influyentes del sertanejo.</li>
            <li><strong>Funk:</strong> Muévete al ritmo del funk con nuestras selecciones más populares.</li>
        </ul>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533"
     crossorigin="anonymous"></script>
<!-- PlusM-H-Horizon -->
<ins class="adsbygoogle"
     style="display:block"
     data-ad-client="ca-pub-7156629532314533"
     data-ad-slot="4960035563"
     data-ad-format="auto"
     data-full-width-responsive="true"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>
<h3>Descubre las biografías de los Artistas más visitados</h3>
<p>Nuestra plataforma se actualiza diariamente con nuevos artistas y canciones. Aquí te presentamos algunos de los más populares que no puedes dejar de conocer:</p>

<?php
// Conexión a la base de datos
$db_host = 'localhost';
$db_user = 'plusmusi_owner';
$db_pass = '^@#F-NBx3W}+';
$db_name = 'plusmusi_data';

try {
    $conectar = new mysqli($db_host, $db_user, $db_pass, $db_name);
    if ($conectar->connect_error) {
        throw new Exception("Error de conexión: " . $conectar->connect_error);
    }
    $conectar->set_charset("utf8mb4");
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
    exit();
}

// Consulta para obtener las 5 biografías más visitadas
$sql = "SELECT artista, link_bioartista, biografia FROM biografias ORDER BY num_visitas DESC LIMIT 5";
$result = $conectar->query($sql);

if ($result->num_rows > 0) {
    echo '<ul>';
    
    while($row = $result->fetch_assoc()) {
        $artista = htmlspecialchars($row['artista']);
        $link_bioartista = htmlspecialchars($row['link_bioartista']);
        
        // Remover la pregunta inicial "¿Qué se sabe de ..." y cualquier etiqueta HTML
        $biografia = strip_tags(preg_replace('/<h2>¿Qué se sabe de .*?<\/h2>/i', '', $row['biografia']));
        
        // Limitar la descripción a 200 caracteres para mantener el formato limpio
        $descripcion = substr($biografia, 0, 200) . '...';
        
        // Generar el enlace a la biografía completa
        echo '<li><a href="/biografia/' . $link_bioartista . '" title="Leer biografía completa de ' . $artista . '"><strong>' . $artista . ':</strong></a> ' . $descripcion . '</li>';
    }
    
    echo '</ul>';
} else {
    echo "No se encontraron biografías.";
}

// Cerrar la conexión a la base de datos
$conectar->close();
?>
<div class="leer-mas-bio">
    <a href="/biografias/" class="btn-leer-mas">Leer más Biografías</a>
</div>
        
        <h3>Reseñas de Álbumes</h3>
        <p>Consulta nuestras reseñas de los últimos lanzamientos y descubre nuestra opinión sobre los álbumes más esperados.</p>

<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533"
     crossorigin="anonymous"></script>
<!-- PlusM-H-728 -->
<ins class="adsbygoogle"
     style="display:inline-block;width:728px;height:90px"
     data-ad-client="ca-pub-7156629532314533"
     data-ad-slot="4262999167"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>

    </div>
</section>

<hr class="line">

<div class="g-1">
    <div id="js-albums-home" data-page="home">

<div class="h1">Artistas más escuchados</div>
<div class="filter cnt-filter_tabs">
    <a class="js-tab-link on" href="/generos/" title="Ver todos los géneros">Todos</a>
    <a class="js-tab-link" href="/rock/" title="Ver género Rock">Rock</a>
    <a class="js-tab-link" href="/reggaeton/" title="Ver género Reggaeton">Reggaeton</a>
    <a class="js-tab-link" href="/sertanejo/" title="Ver género Sertanejo">Sertanejo</a>
    <a class="js-tab-link" href="/funk/" title="Ver género Funk">Funk</a>
    <div class="filter_more">
<a class="js-filter-more-genre" href="/generos/" title="Ver más géneros">Mas</a>
    </div>
</div>
<div class="g-fix g-mb tile--alb">
   <?php
		   function limpiar_url($cadena) {
    // Lógica para limpiar la cadena y generar una URL amigable
    // Puedes implementar la lógica según tus necesidades
    // Aquí hay un ejemplo simple que convierte espacios en guiones bajos y elimina caracteres especiales
    $cadena = strtolower($cadena);
    $cadena = preg_replace('/[^a-z0-9]+/', '-', $cadena);
    $cadena = trim($cadena, '-');
    return $cadena;
}

// Establece la conexión a tu base de datos (reemplaza con tus propios datos de conexión)
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("La conexión falló: " . $conn->connect_error);
}

$bloqueartistas = 6;

$query = "SELECT genero, artista FROM artistas WHERE genero != 'Varios Artistas' ORDER BY Hits DESC LIMIT 0, $bloqueartistas";

$result = $conn->query($query);

if ($result->num_rows > 0) {
    echo '<div class="g-fix g-mb tile--large">';
    while ($row = $result->fetch_assoc()) {
$artista = $row["artista"];
$genero = $row["genero"];

// Consulta para obtener el número de canciones del artista
$canciones_query = "SELECT COUNT(*) AS total_canciones FROM canciones WHERE artista = ?";
$canciones_stmt = $conn->prepare($canciones_query);
$canciones_stmt->bind_param("s", $artista);
$canciones_stmt->execute();
$canciones_stmt->bind_result($total_canciones);
$canciones_stmt->fetch();
$canciones_stmt->close();

// Enlace para el artista
$artista_url = "" . limpiar_url($genero) . "/" . limpiar_url($artista) . "/";

// Imagen del artista (sustituye con tu lógica para obtener la imagen)
$imagen_url = "https://tse2.mm.bing.net/th?q=" . urlencode(str_replace(" ", "+", $artista)) . "&w=155&h=155&c=7&rs=1&...";

echo '<a class="tile g-1-6" href="' . $artista_url . '">';
echo '<img loading=\"lazy\"  src="' . $imagen_url . '" alt="Escuchar ' . $artista . '" width="155" height="auto">';
echo '<b>' . $total_canciones . ' Canciones</b>';
echo '<span>' . $artista . '</span>';
echo '</a>';
    }
    echo '</div>';
} else {
    echo "No se encontraron resultados.";
}

$conn->close();
?>


</div>
    </div>
</div>

<div class="add-container">
    <div class="add-block large-add">
        <span>ANUNCIO PUBLICITARIO</span>
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-7156629532314533"
     crossorigin="anonymous"></script>
<ins class="adsbygoogle"
     style="display:inline-block;width:1000px;height:360px"
     data-ad-client="ca-pub-7156629532314533"
     data-ad-slot="8557467399"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>
		
    </div>
</div><!-- newm-iz -->

<hr class="line">

<div class="g-1 g-mb g-pr js-ajax-include" data-src="/bundled_artists_playlists.ssi" data-lazy="true">
    <h2 class="h1">Últimos Agregados</h2>
    <div class="g-fix">
<?php
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("La conexión falló: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

$query = "SELECT DISTINCT genero, artista FROM canciones ORDER BY id DESC LIMIT 5";
$resultado = mysqli_query($conn, $query);

if ($resultado) {
    while ($fila = mysqli_fetch_assoc($resultado)) {
$genero = $fila['genero'];
$artista = $fila['artista'];

// Obtener las dos últimas canciones del artista
$query_canciones = "SELECT cancion FROM canciones WHERE artista = '$artista' ORDER BY id DESC LIMIT 2";
$resultado_canciones = mysqli_query($conn, $query_canciones);

// Obtener las canciones del artista
$canciones = array();
while ($fila_canciones = mysqli_fetch_assoc($resultado_canciones)) {
    $canciones[] = $fila_canciones['cancion'];
}

echo '<a href="/' . limpiar_url($genero) . '/' . limpiar_url($artista) . '/" class="bundle g-1-5">
<img loading=\"lazy\" alt="Escuchar ' . $artista . '" src="https://tse2.mm.bing.net/th?q=' . urlencode($artista) . '&w=191&h=191&c=7&rs=1&..." data-lazy="true" width="191" height="auto">
<div>
    <strong>' . $artista . '</strong>';

// Mostrar hasta 2 canciones por artista
foreach ($canciones as $cancion) {
    echo '<b>' . $cancion . '</b>';
}

echo '<span class="bt-ouvir">Escuchar Lista</span>
    </div>
</a>';
    }
} else {
    echo "Error en la consulta: " . mysqli_error($conn);
}

mysqli_close($conn);
?>

    </div>
</div>

<section class="home-selecao g-1 g-mb g-pr">
    <h2 class="h1">Buscar por Género</h2>
    <a href="/top/" class="js-radio-ps_submit home-selecao_submit bt bt-ouvir">Escuchar músicas</a>
</section>


<hr class="line">


<div id="genre-radio">
    <div class="genre g-1 g-mb g-pr scroling">
<?php 
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar la conexión
if ($conn->connect_error) {
    die("La conexión falló: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

// Consulta SQL para obtener los géneros
$sql = "SELECT genero, link_genero, Hits FROM generos ORDER BY Hits DESC LIMIT 32";
$result = $conn->query($sql);

// Verificar si hay resultados
if ($result->num_rows > 0) {
    $contador = 0; // Inicializar el contador
    // Mostrar los géneros
    while($row = $result->fetch_assoc()) {
        // Incrementar el contador
        $contador++;

        // Detener el bucle si el contador alcanza el límite
        if ($contador > 32) {
            break;
        }

        // Incrementar el contador de visitas cuando se hace clic en un género
        if (isset($_GET['genero']) && $_GET['genero'] == $row['genero']) {
            $conn->query("UPDATE generos SET Hits = Hits + 1 WHERE genero = '" . $row['genero'] . "'");
        }

        // Usar `link_genero` en lugar de `genero_url`
        $link_genero = $row["link_genero"];

        // Implementar lazy loading en las imágenes
        echo "<div class=\"genrb\"><a href=\"/" . $link_genero . "/\"><img loading=\"lazy\" src=\"https://fullmusicasvip.webcindario.com/generos/" . $link_genero . ".jpg\" alt=\"Escuchar " . ucwords($row["genero"]) . "\">
        <p>" . ucwords($row["genero"]) . "</p></a>
        </div>";
    }
} else {
    echo "No se encontraron resultados";
}
$conn->close();
?>

 

    </div>
</div>


<footer class="footer">
<div id="pie">
<ul class="lista-tags ultimos">
<?php 
$servername = "localhost";
$username = "plusmusi_owner";
$password = "^@#F-NBx3W}+";
$dbname = "plusmusi_data";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar la conexión
if ($conn->connect_error) {
    die("La conexión falló: " . $conn->connect_error);
}

$estiloscss = array("tag2","tag4","tag2");
$sql = "SELECT genero, artista FROM artistas ORDER BY id DESC LIMIT 30";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
$genero_url = strtolower(str_replace(" ", "-", $row["genero"]));
$artista_url = strtolower(str_replace(" ", "-", $row["artista"]));
$alazar = rand(0, count($estiloscss)-1);
echo "<li><a alt='".$row["artista"]."' title='".$row["artista"]."' href='".$root."/".$genero_url."/".$artista_url."/' class='".$estiloscss[$alazar]."'>".ucwords($row["artista"])."</a></li>";
    }
} else {
    echo "No se encontraron resultados";
}

$conn->close();
?>

 </ul>
<ul class="lista-tags sales">
    <li><a href="/tump3xd.com" title="Tu mp3 XD">Tu mp3 XD</a></li>
    <li><a href="/simp3s.com" title="SiMP3s">SiMP3s</a></li>
    <li><a href="/genteflow.com" title="Genteflow">Genteflow</a></li>
    <li><a href="/foxmusica.com" title="FoxMusica">FoxMusica</a></li>
    <li><a href="/mp3xd.com" title="Mp3xd">Mp3xd</a></li>
    <li><a href="/discosonico.com" title="Discosonico">Discosonico</a></li>
    <li><a href="/ricotono.com" title="Ricotono">Ricotono</a></li>
    <li><a href="/escucharmusic.com" title="EscucharMusic">EscucharMusic</a></li>
    <li><a href="/caleta.com" title="Caleta">Caleta</a></li>
    <li><a href="/foxdisco.com" title="FoxDisco">FoxDisco</a></li>
    <li><a href="/terminos-condiciones.php">Términos y Condiciones</a></li>
    <li><a href="/politica-privacidad.php">Privacidad</a></li>
    <li><a href="/dmca.php">DMCA</a></li>
</ul>
<div class="creditos">
    <span>Este sitio web no almacena ningún archivo de audio o vídeo en sus servidores.</span>
    <span><b>&copy; <?=$anio?> PlusMusicas - Todos los derechos reservados | España - Chile - Argentina - México. </b></span>
</div>

</div>
</footer>

</body>
</html>