<?php
// Conexión a la base de datos
$db_host = 'localhost';
$db_user = 'plusmusi_owner';
$db_pass = '^@#F-NBx3W}+';
$db_name = 'plusmusi_data';

$conectar = new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($conectar->connect_error) {
    die("Error de conexión: " . $conectar->connect_error);
}
$conectar->set_charset("utf8mb4");

// Validar y sanitizar el parámetro offset
$offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
if ($offset < 0) {
    $offset = 0;
}

// Preparar la consulta SQL
$sql = "SELECT id, artista, link_bioartista, biografia, fecha_publicacion FROM biografias ORDER BY id DESC LIMIT 5 OFFSET ?";
$stmt = $conectar->prepare($sql);

if ($stmt) {
    // Vincular el parámetro offset
    $stmt->bind_param('i', $offset);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $artista = $row['artista'];
            $link_bioartista = $row['link_bioartista'];
            $biografia = $row['biografia'];
            
            // Remover la pregunta inicial "¿Qué se sabe de ..."
            $biografia = preg_replace('/<h2>¿Qué se sabe de .*?<\/h2>/i', '', $biografia);

            // Formatear la fecha correctamente
            setlocale(LC_TIME, 'es_ES.UTF-8');
            $fecha_publicacion = strftime("%d de %B, %Y", strtotime($row['fecha_publicacion']));
            
            echo '<div class="news-item">
                    <div class="news-content">
                        <p class="news-date">' . $fecha_publicacion . '</p>
                        <a href="/' . htmlspecialchars($link_bioartista) . '/biografia"><h3>Biografía de ' . htmlspecialchars($artista) . '</h3></a>
                        <p>' . htmlspecialchars(strip_tags(substr($biografia, 0, 200))) . '...</p>
                    </div>
                    <div class="news-image">
                        <a href="/' . htmlspecialchars($link_bioartista) . '/biografia">
                            <img src="https://tse2.mm.bing.net/th?q=' . urlencode($artista) . '+artista&w=300&h=150&c=7&rs=1?.jpg" alt="Foto de ' . htmlspecialchars($artista) . '" title="Biografía de ' . htmlspecialchars($artista) . '">
                        </a>
                    </div>
                </div>';
        }
    } else {
        echo '<p>No hay más biografías para mostrar.</p>';
    }

    // Cerrar la declaración
    $stmt->close();
} else {
    echo '<p>Error en la preparación de la consulta.</p>';
}

// Cerrar la conexión a la base de datos
$conectar->close();
?>
