<?php
// URL del sitio web para obtener la biografía
$url = "https://www.buenamusica.com/" . urlencode($artista) . "/biografia";

// Generar HTML con un contenedor para la biografía
echo "<img class='cover' src='https://tse2.mm.bing.net/th?q=" . urlencode($artista) . "+artista&w=160&h=160&c=7&rs=1&...' alt='Biografia $nombreArtista'>";
echo '<div id="biografia">Cargando biografía...</div>';
?>

<script type="text/javascript">
    // Usar JavaScript para hacer una solicitud a la URL
    fetch("<?= $url ?>")
        .then(response => response.text())
        .then(html => {
            // Crear un DOMParser para analizar el HTML
            var parser = new DOMParser();
            var doc = parser.parseFromString(html, "text/html");

            // Encontrar el div que contiene la biografía
            var biografia = doc.querySelector("#text-speach");

            // Verificar si la biografía fue encontrada
            if (biografia) {
                // Obtener el contenido de la biografía
                var bioContent = biografia.innerHTML;

                // Mostrar la biografía en la página
                document.getElementById("biografia").innerHTML = bioContent;

                // Enviar la biografía al servidor para guardarla en la base de datos
                var formData = new FormData();
                formData.append("artista", "<?= htmlspecialchars($nombreArtista) ?>");
                formData.append("biografia", bioContent);

                fetch("/includes/guardar_biografia.php", {
                    method: "POST",
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    console.log(data); // Mostrar el resultado en la consola
                })
                .catch(error => {
                    console.error("Error al guardar la biografía:", error);
                });
            } else {
                document.getElementById("biografia").innerText = "No se encontró la biografía en la página.";
            }

            // Encontrar el div que contiene los datos del artista
            var artistInfo = doc.querySelector(".artist-info.artist-info-bio");

            // Verificar si se encontraron los datos del artista
            if (artistInfo) {
                // Obtener el contenido de los datos del artista
                var artistContent = artistInfo.innerHTML;

                // Mostrar los datos del artista en la página
                var artistInfoDiv = document.createElement("div");
                artistInfoDiv.id = "artist-info";
                artistInfoDiv.innerHTML = artistContent;
                document.getElementById("biografia").insertAdjacentElement('beforebegin', artistInfoDiv);

                // Enviar los datos del artista al servidor para guardarlos en la base de datos
                formData.append("datos_artista", artistContent);

                fetch("/includes/guardar_datos_artista.php", {
                    method: "POST",
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    console.log(data); // Mostrar el resultado en la consola
                })
                .catch(error => {
                    console.error("Error al guardar los datos del artista:", error);
                });

            } else {
                console.log("No se encontraron datos del artista en la página.");
            }
        })
        .catch(error => {
            document.getElementById("biografia").innerText = "Error al cargar la biografía: " + error.message;
            console.error("Error al cargar los datos del artista:", error.message);
        });
</script>


<?php
// Si no se encuentra la biografía, muestra el mensaje alternativo
echo "<p>¿Quieres escuchar la música de <b>$nombreArtista</b> en línea? ¡Has llegado al lugar indicado! Nuestro sitio web de música en línea te permite disfrutar de las últimas canciones de $nombreArtista y otros artistas destacados. Aunque lamentablemente no contamos con una biografía para $nombreArtista en este momento, aún puedes descubrir y revivir tus canciones favoritas. Escucha música en línea de manera ilimitada, en cualquier momento y lugar de tu elección. Únete a nuestra comunidad en línea y experimenta la mejor música del año $anio.</p>";
?>