<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Datos de Tiago PZK</title>
</head>
<body>
    <div id="artist-info"></div>

    <script>
    // Asumiendo que el contenido está en un script cargado dinámicamente
    document.addEventListener("DOMContentLoaded", function() {
        // Esperar que todo el contenido se cargue
        fetch("https://www.buenamusica.com/kurt-cobain/biografia")
            .then(response => response.text())
            .then(html => {
                let parser = new DOMParser();
                let doc = parser.parseFromString(html, "text/html");

                // Extraer el contenido del script si está cargado dinámicamente
                let artistInfo = doc.querySelector(".artist-info.artist-info-bio");
                if (artistInfo) {
                    document.getElementById("artist-info").innerHTML = artistInfo.innerHTML;
                } else {
                    document.getElementById("artist-info").innerText = "No se encontró contenido en la clase especificada.";
                }
            })
            .catch(error => {
                console.error("Error al obtener la página:", error);
                document.getElementById("artist-info").innerText = "Error al obtener la información.";
            });
    });
    </script>
</body>
</html>
