document.addEventListener('DOMContentLoaded', function() {
    var pagingLinks = document.querySelectorAll('.paging a');
    var slideImages = document.querySelector('.slideimages');
    var slideImagesLinks = document.querySelectorAll('.slideimages a');
    var slideImagesWidth = document.querySelector('.slideimages a').offsetWidth;
    var totalImages = slideImagesLinks.length;
    var currentIndex = 0;
    var intervalId;

    function rotateSwitch() {
        clearInterval(intervalId);
        intervalId = setInterval(function() {
            currentIndex = (currentIndex + 1) % totalImages;
            rotate();
        }, 4000);
    }

    function rotate() {
        var slidePosition = -currentIndex * slideImagesWidth;
        slideImages.style.left = slidePosition + 'px';
        updatePaging();
    }

    function updatePaging() {
        for (var i = 0; i < totalImages; i++) {
            pagingLinks[i].classList.remove('active');
        }
        pagingLinks[currentIndex].classList.add('active');
    }

    for (var i = 0; i < totalImages; i++) {
        pagingLinks[i].addEventListener('click', function(event) {
            event.preventDefault();
            clearInterval(intervalId);
            currentIndex = parseInt(event.target.getAttribute('rel')) - 1;
            rotate();
            rotateSwitch();
        });
    }

    slideImages.addEventListener('mouseover', function() {
        clearInterval(intervalId);
    });

    slideImages.addEventListener('mouseout', function() {
        rotateSwitch();
    });

    // Initial setup
    rotateSwitch();
});
