<?php
$letras = range('A', 'Z');

echo '<div id="artistas-list">';
foreach ($letras as $letra) {
    echo "<h2>$letra</h2>";
    echo "<div id='lista-$letra'>Cargando artistas...</div>";
}
echo '</div>';
?>

<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function() {
    const letras = <?= json_encode($letras) ?>;

    letras.forEach(letra => {
        fetch(`https://www.buenamusica.com/artistas/${letra.toLowerCase()}`)
            .then(response => response.text())
            .then(html => {
                const parser = new DOMParser();
                const doc = parser.parseFromString(html, "text/html");

                // Extrae los artistas de la página
                const artistas = doc.querySelectorAll('.concertCss');
                let listaArtistas = "";

                if (artistas.length > 0) {
                    artistas.forEach(artista => {
                        const nombre = artista.querySelector('b').innerText.trim();
                        const enlace = artista.querySelector('a').getAttribute('href');
                        const imagen = artista.querySelector('img').getAttribute('src');

                        listaArtistas += `
                            <div class="artista">
                                <img src="${imagen}" alt="${nombre}">
                                <a href="${enlace}" target="_blank">${nombre}</a>
                            </div>
                        `;
                    });
                } else {
                    listaArtistas = "<p>No se encontraron artistas.</p>";
                }

                document.getElementById(`lista-${letra}`).innerHTML = listaArtistas;
            })
            .catch(error => {
                document.getElementById(`lista-${letra}`).innerHTML = `Error al cargar artistas: ${error.message}`;
                console.error("Error al cargar los artistas:", error.message);
            });
    });
});
</script>

<style>
    .artista {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
    }
    .artista img {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        margin-right: 10px;
    }
    .artista a {
        text-decoration: none;
        color: #000;
        font-weight: bold;
    }
</style>
