<?php 

date_default_timezone_set('UTC');
require 'vendor/autoload.php';
require 'config.php';
$conexion 	= new PDO($config['mysql'], $config['usuario'], $config['contra'],$opciones);
$db 	    = new NotORM($conexion);
$app   		= new \Slim\Slim();

$app->config(array(
    'debug' => true,
    'templates.path' => './theme'
));

$app->get('/','home');
$app->get('/letras/:abc/?','letra');
$app->get('/search/:search/?','search');
$app->get('/:genero/:artista/?','artista');
$app->get('/:genero/?','genero');
$app->run();

function search($search){
	global $db;
	$app            = \Slim\Slim::getInstance();
	$ap['artistas'] = $db->artistas()->where("artista LIKE '%{$search}%'")->limit(3);
	if($ap['artistas']->count('*') > '3') : 
		$ap['track']    = $db->canciones()->where("artista LIKE '%{$search}%'")->limit(6);
	else :
		$ap['track']    = $db->canciones()->where("cancion LIKE '%{$search}%'")->limit(6);
	endif;
	$app->render('search.html', $ap);
}
function home(){
	global $db;
 	$app = \Slim\Slim::getInstance();
 	$ap['track'] 	= $db->canciones()->limit(10)->order('rand()');
 	$ap['art'] 		= $db->artistas()->limit(10)->order('rand()');
 	$app->render('home.html', $ap);
}
function artista($genero , $artista){
	global $db;
	$app           = \Slim\Slim::getInstance();
	$genero        = antilinks($genero);
	$artista       = antilinks($artista);
	if(validarart($genero,$artista)) : 
		$ap['artista'] = $artista;
		$ap['genero']  = $genero;
		$ap['track']   = $db->canciones('artista', $artista)->where('genero',$genero)->order('cancion ASC');
	else : 
		$app->redirect('/');
	endif;
	$app->render('artista.html',$ap);
}
function letra($abc){
	global $db;
	$app            = \Slim\Slim::getInstance();
	$abc            = antilinks($abc);
	if(strlen($abc) <= '1') :
		if($abc         == '1') :
			$ap['genero']   = $abc;
			$ap['artistas'] = $db->artistas()->where(" artista RLIKE '^[0-9]'")->order('artista DESC');
			$ap['track']    = $db->canciones()->where(" artista RLIKE '^[0-9]'")->order('rand()')->limit(10);
		else:
			$ap['genero']   = $abc;
			$ap['artistas'] = $db->artistas()->where('SUBSTRING(artista,1,1) = ?',$abc);
			$ap['track']    = $db->canciones()->where('SUBSTRING(artista,1,1) = ?',$abc)->order('rand()')->limit(10);
		endif;
	else : 
		$app->redirect('/');
	endif;
	$app->render('genero.html',$ap);
}
function genero($genero){
	global $db;
	$app            = \Slim\Slim::getInstance();
	$genero         = antilinks($genero);
	if(validargen($genero)) : 
		$ap['genero']   = $genero;
		$ap['artistas'] = $db->artistas()->where('genero',$genero)->order('artista ASC');
		$ap['track']    = $db->canciones()->where('genero',$genero)->order('rand()')->limit(10);
	else : 
		$app->redirect('/');
	endif;
	$app->render('genero.html',$ap);
}



?>